// FunctionDamageFormula.js Ver.1.0.2
// MIT License (C) 2021 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
*
* @plugindesc ダメージ計算を高速化します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/
* @help
* 【使い方】
* プラグイン導入前と変わりません。
* 他のスキルの計算式を参照する場合は
* _sf[スキルID]
* と入力してください。

* 他のアイテムの計算式を参照する場合は
* _if[アイテムID]
* と入力してください。
*
* このプラグインの関数化機能を使いたくない計算式がある場合はメモに
* <useEval>
* と書き込んでください。
*
* 【仕様】
* 計算の度にeval() 関数で処理していたものをFunction() コンストラクターで事前に
* 定義しておくことで高速化します。
* そのため、ダメージ計算式内でif文が使えなくなるので三項演算子で代用して下さい。
* またダメージ計算式を拡張するプラグインを使用している場合は不具合が出る
* 可能性があります。
* 
*
* [更新履歴]
* 2021/07/27：Ver.1.0.0　公開
* 2021/07/28：Ver.1.0.1　従来の仕様を再現するタグを追加。
* 2021/08/01：Ver.1.0.2　バグ修正。コードの整理。
* 2021/08/02：Ver.1.0.3　コードの整理。
*
*/

'use strict'
{
	//プラグイン名取得
	const pluginName = document.currentScript.src.replace(/^.*\/(.*).js$/, function() {
		return arguments[1];
	});
	//プラグインパラメーター取得
	const param = PluginManager.parameters(pluginName);
	const useScript = param['useScript'] === 'true';
	const isHit = param['isHit'] === 'true';
	
	//データベース読み込みが完了して起動準備ができた時に割り込む
	const _Scene_Boot_isReady  = Scene_Boot.prototype.isReady;
	Scene_Boot.prototype.isReady = function() {
		if (_Scene_Boot_isReady.call(this)) {
			addDamageFormula();
		}
		return _Scene_Boot_isReady.call(this);
	};

	function addDamageFormula() {
		analyticsDamageFormula($dataSkills);
		analyticsDamageFormula($dataItems);
	};

	function analyticsDamageFormula($data) {
		for (const item of $data) {
			if (item && item.damage) {
				//スキルの引用符を正しいプロパティ名に変換
				item.damage.formula = item.damage.formula.replace(/_sf\[(.+?)\]/g, "$dataSkills[$1].damage.funcFormula(a,b,v,$dataSkills[$1].damage.formula)");
				item.damage.formula = item.damage.formula.replace(/_if\[(.+?)\]/g, "$dataItems[$1].damage.funcFormula(a,b,v,$dataItems[$1].damage.formula)");
				//ダメージ計算式を関数に変換
				item.damage.funcFormula = item.meta.useEval ? new Function('a','b','v','formula',"return eval(formula)") : new Function('a','b','v',"return " + item.damage.formula);
			}
		}
	};
	
	Game_Action.prototype.evalDamageFormula = function(target) {
		try {
			const item = this.item();
			const a = this.subject();
			const b = target;
			const v = $gameVariables._data;
			const sign = [3, 4].includes(item.damage.type) ? -1 : 1;
			const formula = item.damage.funcFormula.call(this, a, b, v, item.damage.formula);
			const value = Math.max(formula, 0) * sign;
			return isNaN(value) ? 0 : value;
		} catch (e) {
			return 0;
		}
	};
}